/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui.debug;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0004\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jediterm/ui/debug/TeseqVisualizer;", "", "<init>", "()V", "apply", "", "", "chunks", "text", "createTempFile", "Ljava/io/File;", "writeTextToTempFile", "readOutput", "command", "JediTerm"})
@SourceDebugExtension(value={"SMAP\nTeseqVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeseqVisualizer.kt\ncom/jediterm/ui/debug/TeseqVisualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1563#2:55\n1634#2,3:56\n*S KotlinDebug\n*F\n+ 1 TeseqVisualizer.kt\ncom/jediterm/ui/debug/TeseqVisualizer\n*L\n10#1:55\n10#1:56,3\n*E\n"})
public final class TeseqVisualizer {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> apply(@NotNull List<String> chunks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chunks, "chunks");
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.apply((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final String apply(String text) {
        Object object;
        try {
            File file = this.writeTextToTempFile(text);
            String[] stringArray = new String[]{"teseq", file.getAbsolutePath()};
            object = this.readOutput(CollectionsKt.listOf(stringArray));
        }
        catch (IOException e) {
            object = "(!) Control sequence visualizer `teseq` is not installed (http://www.gnu.org/software/teseq/).\nPrinting characters as is:\n" + text;
        }
        return object;
    }

    private final File createTempFile() {
        File file;
        File it = file = File.createTempFile("jediterm-data", ".txt");
        boolean bl = false;
        it.deleteOnExit();
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue(file2, "also(...)");
        return file2;
    }

    private final File writeTextToTempFile(String text) throws IOException {
        File file = this.createTempFile();
        FilesKt.writeText(file, text, Charsets.UTF_8);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readOutput(List<String> command) throws IOException {
        String string;
        Process process = new ProcessBuilder(command).start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Closeable closeable = reader;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            string = TextStreamsKt.readText(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return string;
    }
}

